<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use BezhanSalleh\FilamentShield\Support\Utils;
use Spatie\Permission\PermissionRegistrar;

class ShieldSeeder extends Seeder
{
    public function run(): void
    {
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        $rolesWithPermissions = '[{"name":"super_admin","guard_name":"web","permissions":["view_role","view_any_role","create_role","update_role","delete_role","delete_any_role","view_activitylog","view_any_activitylog","create_activitylog","update_activitylog","restore_activitylog","restore_any_activitylog","replicate_activitylog","reorder_activitylog","delete_activitylog","delete_any_activitylog","force_delete_activitylog","force_delete_any_activitylog","view_asset","view_any_asset","create_asset","update_asset","restore_asset","restore_any_asset","replicate_asset","reorder_asset","delete_asset","delete_any_asset","force_delete_asset","force_delete_any_asset","view_asset::category","view_any_asset::category","create_asset::category","update_asset::category","restore_asset::category","restore_any_asset::category","replicate_asset::category","reorder_asset::category","delete_asset::category","delete_any_asset::category","force_delete_asset::category","force_delete_any_asset::category","view_borrower","view_any_borrower","create_borrower","update_borrower","restore_borrower","restore_any_borrower","replicate_borrower","reorder_borrower","delete_borrower","delete_any_borrower","force_delete_borrower","force_delete_any_borrower","view_branches","view_any_branches","create_branches","update_branches","restore_branches","restore_any_branches","replicate_branches","reorder_branches","delete_branches","delete_any_branches","force_delete_branches","force_delete_any_branches","view_bulk::repayments","view_any_bulk::repayments","create_bulk::repayments","update_bulk::repayments","restore_bulk::repayments","restore_any_bulk::repayments","replicate_bulk::repayments","reorder_bulk::repayments","delete_bulk::repayments","delete_any_bulk::repayments","force_delete_bulk::repayments","force_delete_any_bulk::repayments","view_contact::messages","view_any_contact::messages","create_contact::messages","update_contact::messages","restore_contact::messages","restore_any_contact::messages","replicate_contact::messages","reorder_contact::messages","delete_contact::messages","delete_any_contact::messages","force_delete_contact::messages","force_delete_any_contact::messages","view_direct::debit::mandate::settings","view_any_direct::debit::mandate::settings","create_direct::debit::mandate::settings","update_direct::debit::mandate::settings","restore_direct::debit::mandate::settings","restore_any_direct::debit::mandate::settings","replicate_direct::debit::mandate::settings","reorder_direct::debit::mandate::settings","delete_direct::debit::mandate::settings","delete_any_direct::debit::mandate::settings","force_delete_direct::debit::mandate::settings","force_delete_any_direct::debit::mandate::settings","view_employee","view_any_employee","create_employee","update_employee","restore_employee","restore_any_employee","replicate_employee","reorder_employee","delete_employee","delete_any_employee","force_delete_employee","force_delete_any_employee","view_expense","view_any_expense","create_expense","update_expense","restore_expense","restore_any_expense","replicate_expense","reorder_expense","delete_expense","delete_any_expense","force_delete_expense","force_delete_any_expense","view_expense::category","view_any_expense::category","create_expense::category","update_expense::category","restore_expense::category","restore_any_expense::category","replicate_expense::category","reorder_expense::category","delete_expense::category","delete_any_expense::category","force_delete_expense::category","force_delete_any_expense::category","view_loan","view_any_loan","create_loan","update_loan","restore_loan","restore_any_loan","replicate_loan","reorder_loan","delete_loan","delete_any_loan","force_delete_loan","force_delete_any_loan","view_loan::agreement::forms","view_any_loan::agreement::forms","create_loan::agreement::forms","update_loan::agreement::forms","restore_loan::agreement::forms","restore_any_loan::agreement::forms","replicate_loan::agreement::forms","reorder_loan::agreement::forms","delete_loan::agreement::forms","delete_any_loan::agreement::forms","force_delete_loan::agreement::forms","force_delete_any_loan::agreement::forms","view_loan::restructure","view_any_loan::restructure","create_loan::restructure","update_loan::restructure","restore_loan::restructure","restore_any_loan::restructure","replicate_loan::restructure","reorder_loan::restructure","delete_loan::restructure","delete_any_loan::restructure","force_delete_loan::restructure","force_delete_any_loan::restructure","view_loan::roll::over","view_any_loan::roll::over","create_loan::roll::over","update_loan::roll::over","restore_loan::roll::over","restore_any_loan::roll::over","replicate_loan::roll::over","reorder_loan::roll::over","delete_loan::roll::over","delete_any_loan::roll::over","force_delete_loan::roll::over","force_delete_any_loan::roll::over","view_loan::settlement::forms","view_any_loan::settlement::forms","create_loan::settlement::forms","update_loan::settlement::forms","restore_loan::settlement::forms","restore_any_loan::settlement::forms","replicate_loan::settlement::forms","reorder_loan::settlement::forms","delete_loan::settlement::forms","delete_any_loan::settlement::forms","force_delete_loan::settlement::forms","force_delete_any_loan::settlement::forms","view_loan::type","view_any_loan::type","create_loan::type","update_loan::type","restore_loan::type","restore_any_loan::type","replicate_loan::type","reorder_loan::type","delete_loan::type","delete_any_loan::type","force_delete_loan::type","force_delete_any_loan::type","view_messages","view_any_messages","create_messages","update_messages","restore_messages","restore_any_messages","replicate_messages","reorder_messages","delete_messages","delete_any_messages","force_delete_messages","force_delete_any_messages","view_payroll::run","view_any_payroll::run","create_payroll::run","update_payroll::run","restore_payroll::run","restore_any_payroll::run","replicate_payroll::run","reorder_payroll::run","delete_payroll::run","delete_any_payroll::run","force_delete_payroll::run","force_delete_any_payroll::run","view_payslip","view_any_payslip","create_payslip","update_payslip","restore_payslip","restore_any_payslip","replicate_payslip","reorder_payslip","delete_payslip","delete_any_payslip","force_delete_payslip","force_delete_any_payslip","view_repayments","view_any_repayments","create_repayments","update_repayments","restore_repayments","restore_any_repayments","replicate_repayments","reorder_repayments","delete_repayments","delete_any_repayments","force_delete_repayments","force_delete_any_repayments","view_salary::scale","view_any_salary::scale","create_salary::scale","update_salary::scale","restore_salary::scale","restore_any_salary::scale","replicate_salary::scale","reorder_salary::scale","delete_salary::scale","delete_any_salary::scale","force_delete_salary::scale","force_delete_any_salary::scale","view_subscriptions","view_any_subscriptions","create_subscriptions","update_subscriptions","restore_subscriptions","restore_any_subscriptions","replicate_subscriptions","reorder_subscriptions","delete_subscriptions","delete_any_subscriptions","force_delete_subscriptions","force_delete_any_subscriptions","view_switch::branch","view_any_switch::branch","create_switch::branch","update_switch::branch","restore_switch::branch","restore_any_switch::branch","replicate_switch::branch","reorder_switch::branch","delete_switch::branch","delete_any_switch::branch","force_delete_switch::branch","force_delete_any_switch::branch","view_tax::band","view_any_tax::band","create_tax::band","update_tax::band","restore_tax::band","restore_any_tax::band","replicate_tax::band","reorder_tax::band","delete_tax::band","delete_any_tax::band","force_delete_tax::band","force_delete_any_tax::band","view_third::party","view_any_third::party","create_third::party","update_third::party","restore_third::party","restore_any_third::party","replicate_third::party","reorder_third::party","delete_third::party","delete_any_third::party","force_delete_third::party","force_delete_any_third::party","view_transactions","view_any_transactions","create_transactions","update_transactions","restore_transactions","restore_any_transactions","replicate_transactions","reorder_transactions","delete_transactions","delete_any_transactions","force_delete_transactions","force_delete_any_transactions","view_transfers","view_any_transfers","create_transfers","update_transfers","restore_transfers","restore_any_transfers","replicate_transfers","reorder_transfers","delete_transfers","delete_any_transfers","force_delete_transfers","force_delete_any_transfers","view_user","view_any_user","create_user","update_user","restore_user","restore_any_user","replicate_user","reorder_user","delete_user","delete_any_user","force_delete_user","force_delete_any_user","view_wallet","view_any_wallet","create_wallet","update_wallet","restore_wallet","restore_any_wallet","replicate_wallet","reorder_wallet","delete_wallet","delete_any_wallet","force_delete_wallet","force_delete_any_wallet","page_ProfileCompletion","widget_StatsOverview","widget_PrincipleReleased","widget_TotalCollected","widget_Expenses","widget_OutstandingBalance"]},{"name":"panel_user","guard_name":"web","permissions":[]}]';
        $directPermissions = '[]';

        static::makeRolesWithPermissions($rolesWithPermissions);
        static::makeDirectPermissions($directPermissions);

        $this->command->info('Shield Seeding Completed.');
    }

    protected static function makeRolesWithPermissions(string $rolesWithPermissions): void
    {
        if (! blank($rolePlusPermissions = json_decode($rolesWithPermissions, true))) {
            /** @var Model $roleModel */
            $roleModel = Utils::getRoleModel();
            /** @var Model $permissionModel */
            $permissionModel = Utils::getPermissionModel();

            foreach ($rolePlusPermissions as $rolePlusPermission) {
                $role = $roleModel::firstOrCreate([
                    'name' => $rolePlusPermission['name'],
                    'guard_name' => $rolePlusPermission['guard_name'],
                ]);

                if (! blank($rolePlusPermission['permissions'])) {
                    $permissionModels = collect($rolePlusPermission['permissions'])
                        ->map(fn ($permission) => $permissionModel::firstOrCreate([
                            'name' => $permission,
                            'guard_name' => $rolePlusPermission['guard_name'],
                        ]))
                        ->all();

                    $role->syncPermissions($permissionModels);
                }
            }
        }
    }

    public static function makeDirectPermissions(string $directPermissions): void
    {
        if (! blank($permissions = json_decode($directPermissions, true))) {
            /** @var Model $permissionModel */
            $permissionModel = Utils::getPermissionModel();

            foreach ($permissions as $permission) {
                if ($permissionModel::whereName($permission)->doesntExist()) {
                    $permissionModel::create([
                        'name' => $permission['name'],
                        'guard_name' => $permission['guard_name'],
                    ]);
                }
            }
        }
    }
}
