<script src="https://pay.lenco.co/js/v1/inline.js"></script>
<script>
    function makePaymentsWithLenco() {
        LencoPay.getPaid({
            key: "<?php echo e(env('LENCO_PUBLIC_KEY')); ?>",
            reference: 'ref-' + Date.now(),
            email: "<?php echo e(auth()->user()->email); ?>",
            amount: <?php echo e($amount); ?>,
            currency: "ZMW",
            channels: ["card", "mobile-money"],
            customer: {
                firstName: "<?php echo e(auth()->user()->name); ?>",
                lastName: "",
                phone: "",
            },
            onSuccess: function (response) {
                let formData = new FormData();
                formData.append("_token", "<?php echo e(csrf_token()); ?>");
                formData.append("data", JSON.stringify(response));

                fetch("<?php echo e(route('completeSubscription', $amount)); ?>", {
                    method: "POST",
                    body: formData,
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === "success") {
                        window.location.href = "/admin";
                    } else {
                        console.error("Unexpected response:", data);
                        alert("Something went wrong: " + (data.message || ''));
                        window.location.href = "/admin";
                    }
                })
                .catch(error => {
                    console.error("Fetch error:", error);
                    alert("Failed to complete the request. Please try again.");
                });
            },
            onClose: function () {
                alert('Payment was not complete, please try again.');
                window.location.href = "/admin";
            },
            onConfirmationPending: function () {
                alert('Your subscription will be completed when the payment is confirmed');
            },
        });
    }

    // Auto-trigger on page load
    window.addEventListener('DOMContentLoaded', function () {
        makePaymentsWithLenco();
    });
</script>
<?php /**PATH /home/neocash/public_html/resources/views/gateways/lenco/lencoPayments.blade.php ENDPATH**/ ?>